// ==UserScript==
// @name         企信工作台 - 极简高位版
// @namespace    http://tampermonkey.net/
// @version      2.1
// @description  位置往上移动，字体不加粗，增加Hover效果
// @author       User
// @match        https://qx.ynydtk.cn:8443/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function() {
	'use strict';

	const targetModules = ["业财融合", "供应链系统(new)"];
	const targetUrl = "https://qx.ynydtk.cn:8443/?#/workbench/index";
	const myContainerId = "my-custom-container";

	function rebuildPage() {
		if (window.location.href !== targetUrl) {
			const existing = document.getElementById(myContainerId);
			if (existing) existing.remove();
			return;
		}

		const allDivs = document.querySelectorAll('.ut-flex.ut-flex-wrap.ut-w-full > div');
		let foundApps = [];

		allDivs.forEach(div => {
			const text = div.innerText.trim();
			if (targetModules.some(name => text.includes(name))) {
				foundApps.push(div);
			}
		});

		if (foundApps.length < 2) return;

		const mainContent = document.querySelector('.ut-overflow-y-auto.ut-w-full');
		if (mainContent) {
			Array.from(mainContent.children).forEach(child => {
				if (child.id !== myContainerId) child.style.display = 'none';
			});

			let myContainer = document.getElementById(myContainerId);
			if (!myContainer) {
				myContainer = document.createElement('div');
				myContainer.id = myContainerId;
				Object.assign(myContainer.style, {
					display: 'flex',
					justifyContent: 'center', // 水平居中
					alignItems: 'flex-start',  // 【修改】改为顶部对齐
					width: '100%',
					height: '100%',
					paddingTop: '15vh',        // 【核心】距离顶部15%的高度，位置偏上
					gap: '40px',
					boxSizing: 'border-box'
				});
				mainContent.appendChild(myContainer);
			}

			foundApps.forEach(app => {
				// 1. 卡片基础样式
				Object.assign(app.style, {
					display: 'flex',
					flexDirection: 'row',
					alignItems: 'center',
					justifyContent: 'center',
					height: '80px',
					width: '260px',
					backgroundColor: '#ffffff',
					borderRadius: '10px',
					border: '1px solid #ebeef5',
					boxShadow: '0 2px 12px 0 rgba(0,0,0,0.05)',
					transition: 'all 0.3s ease',
					cursor: 'pointer',
					padding: '0 20px',
					boxSizing: 'border-box',
					overflow: 'hidden'
				});

				// 2. Hover 效果
				app.onmouseenter = () => {
					app.style.backgroundColor = '#f5f7fa';
					app.style.transform = 'translateY(-5px)';
					app.style.boxShadow = '0 8px 20px rgba(0,0,0,0.1)';
					app.style.borderColor = '#409eff';
				};
				app.onmouseleave = () => {
					app.style.backgroundColor = '#ffffff';
					app.style.transform = 'translateY(0)';
					app.style.boxShadow = '0 2px 12px 0 rgba(0,0,0,0.05)';
					app.style.borderColor = '#ebeef5';
				};

				// 3. 清理内部
				const allInner = app.querySelectorAll('*');
				allInner.forEach(el => {
					el.style.backgroundColor = 'transparent';
					el.style.border = 'none';
					el.style.boxShadow = 'none';
					el.style.width = 'auto';
					el.style.height = 'auto';
				});

				// 4. 图标
				const icon = app.querySelector('img, svg, [class*="ut-w-"]');
				if (icon) {
					icon.style.width = '36px';
					icon.style.height = '36px';
					icon.style.marginRight = '15px';
					icon.style.flexShrink = '0';
				}

				// 5. 文字：不加粗，不换行
				const textContainer = app.querySelector('.ut-px-1') || app.querySelector('div:last-child');
				if (textContainer) {
					Object.assign(textContainer.style, {
						fontSize: '17px',
						fontWeight: '400',
						color: '#606266',
						whiteSpace: 'nowrap',
						textAlign: 'left'
					});
					const innerSpan = textContainer.querySelector('span');
					if (innerSpan) {
						innerSpan.style.fontWeight = '400';
						innerSpan.style.whiteSpace = 'nowrap';
					}
				}

				if (app.parentElement !== myContainer) {
					myContainer.appendChild(app);
				}
			});
		}
	}

	const observer = new MutationObserver(() => {
		if (window.location.href === targetUrl) rebuildPage();
	});

	observer.observe(document.body, { childList: true, subtree: true });
	setTimeout(rebuildPage, 500);
	setInterval(() => { if (window.location.href === targetUrl) rebuildPage(); }, 2000);
})();